function [EHj] = equation_solving(C, E0, k0, pos, Z0)

% Second step in CDDA calculations: obtaining the E and H field acting 
% over each magneto-electric dipole. There are many ways of solving the 
% system of linear coupled equations. Here we use the matlab defined
% method linsolve. This program writes properly the system of equations 
% and solve them with the linsolve function defined in Matlab

%%%%%% INPUT ARGUMENTS %%%%%%
%%% C:   global coupling matrix                                %%%
%%% E0:  exciting electromagnetic wave (6D vectorial function) %%%
%%% k0:  wavenumber                                            %%%
%%% pos: position of the dipoles                               %%%
%%% Z0:  surrounding impedance                                 %%%


%%%%%% OUTPUT ARGUMENTS %%%%%%
%%% EHj: total incident field (exciting wave + scattered field) in the %%%
%%%      dipoles %%%

% Output format: [E1x E1x E1z H1x H1y H1z
%                 E2x E2y E2z H2x H2y H2z
%                 ...
%                 ENx ENy ENz HNx HNy HNz]

% Checking global coupling matrix %
if(mod(sqrt(numel(C)),6)>0)
    
    fprintf('Not apropiated number of dipoles')
    
end


% Defining independent coefficients of the system of equations %
N  = length(pos(:,1));
B  = zeros(6*N,1);

for k = 1:6:6*N
    r(1,:) = pos((k+5)/6,:);
    EHi = E0(Z0,k0,r);
    B(k:k+2)   = -EHi(1:3);
    B(k+3:k+5) = -EHi(4:6);
end              

% Solving the system of equations %
Ecd   = linsolve(C,B);

% Adapting the solution to the correct format %
EHj    = zeros(length(Ecd)/6,6);
for i = 1:6:length(Ecd)
    
    EHj((i+5)/6,1:3) = Ecd(i:i+2);
    EHj((i+5)/6,4:6) = Ecd(i+3:i+5);
        
end


end

